package li.vin.my.apikit.services

import li.vin.my.apikit.api.OdometerAPI
import li.vin.my.apikit.models.Odometer
import li.vin.my.apikit.models.OdometerPost
import li.vin.my.apikit.models.OdometerPostData
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints
import java.text.SimpleDateFormat
import java.util.*

class OdometerService(val value: Int, val unit: String) : BaseService<Odometer>() {
    override fun createCall() {
        val request = createService(OdometerAPI::class.java, Endpoints.getDistanceUrl())
        val sdf = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US)
        val formattedDate = sdf.format(Date().time - 10800000)
        val odometerPost = OdometerPost(OdometerPostData(value, formattedDate, unit))
        call = request.setOdometer(getVehicleId(), odometerPost)
    }
}