package li.vin.my.apikit.services

import li.vin.my.apikit.api.DeviceAPI
import li.vin.my.apikit.models.DriverDevice
import li.vin.my.apikit.models.IconPostBody
import li.vin.my.apikit.models.IconPostBodySlug
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class DeviceIconUpdateService(val icon: String?, val deviceID: String) : BaseService<DriverDevice>() {

    override fun createCall() {
        val request = createService(DeviceAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.updateDeviceIcon(getDriverId(), deviceID, IconPostBody(IconPostBodySlug(icon)), getAuthToken()
        )
    }


}