package li.vin.my.apikit.api

import li.vin.my.apikit.models.TripScore
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * 11/7/18.
 */
interface TripScoreAPI {

    @GET("/api/v1/devices/{deviceId}/trip_score")
    fun getTripScoreDeprecated(
        @Path("deviceId") deviceId: String,
        @Query("since") since: Long,
        @Header("Authorization") sessionCookie: String
    ): Call<TripScore>

    @GET("/api/v1/drivers/{driverId}/trip_score")
    fun getTripScore(
        @Path("driverId") driverId: String,
        @Query("since") since: Long,
        @Header("Authorization") sessionCookie: String
    ): Call<TripScore>
}