package li.vin.my.apikit.api

import li.vin.my.apikit.models.Session
import li.vin.my.apikit.models.UserLogin
import retrofit2.Call
import retrofit2.http.*

/**
 * 12/10/18.
 */
interface SessionAPI {

    @GET("/api/v1/sessions/_current")
    fun getCurrentSession(
        @Header("Authorization") sessionCookie: String,
        @Query("clientId") clientId: String
    ): Call<Session>

    @POST("/api/v1/sessions")
    fun createNewSession(@Body sessionWrapper: UserLogin): Call<Session>

    @DELETE("/api/v1/sessions/_current")
    fun deleteCurrentSession(@Header("Authorization") sessionCookie: String): Call<Void>
}