package li.vin.my.apikit.api

import li.vin.my.apikit.models.*
import retrofit2.Call
import retrofit2.http.*

/**
 * 12/11/18.
 */
interface DeviceAPI {

    @GET("/api/v1/devices")
    fun getDevices(@Header("Authorization") sessionCookie: String): Call<Vehicle>

    @GET("/api/v1/drivers/{driverId}/devices")
    fun getDriverDevices(@Header("Authorization") sessionCookie: String,
                         @Path("driverId") driverId: String): Call<DriverDevices>

    @GET("/api/v1/devices/{deviceId}")
    fun getDeviceDetails(
        @Path("deviceId") deviceId: String,
        @Header("Authorization") sessionCookie: String
    ): Call<Device>

    @GET("/api/v1/driverDevices/icons")
    fun getDeviceIcons(
        @Header("Authorization") sessionCookie: String
    ): Call<Icons>

    @PUT("/api/v2/drivers/{driverId}/driverDevice/{deviceId}/icon")
    fun updateDeviceIcon(
        @Path("driverId") driverId: String,
        @Path("deviceId") deviceId: String,
        @Body body: IconPostBody,
        @Header("Authorization") sessionCookie: String
    ): Call<DriverDevice>

    @Multipart
    @POST("/api/v1/devices")
    fun createDevice(
        @Part("device[name]") name: String,
        @Part("device[iconImage]") iconImage: String, @Part("device[caseId]") caseId: String,
        @Header("Authorization") sessionCookie: String
    ): Call<Device>

    @Multipart
    @PUT("/api/v1/drivers/{driverId}/driverDevice/{deviceId}/icon")
    fun updateIcon(
        @Path("driverId") driverId: String,
        @Path("deviceId") deviceId: String,
        @Part("driverDevice[iconImage]") iconImage: String,
        @Header("Authorization") sessionCookie: String
    ): Call<DriverDevice>

    @Multipart
    @PUT("/api/v1/devices/{deviceId}")
    fun updateDevice(
        @Path("deviceId") deviceId: String,
        @Part("device[name]") name: String, @Part("device[iconImage]") iconImage: String,
        @Part("device[caseId]") caseId: String, @Header("Authorization") sessionCookie: String
    ): Call<Device>

    @DELETE("/api/v1/devices/{deviceId}")
    fun deleteDevice(
        @Path("deviceId") deviceId: String,
        @Header("Authorization") sessionCookie: String
    ): Call<Void>

    @POST("/api/v1/devices/{deviceId}/replacements")
    fun replaceDevice(
        @Body caseId: CaseId, @Path("deviceId") deviceId: String,
        @Header("Authorization") sessionCookie: String
    ): Call<Void>

    @GET("/api/v1/cases/{caseId}/claimed")
    fun getCaseClaimed(@Path("caseId") caseId: String): Call<Claimed>
}