package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

/**
 * 1/18/19.
 */
data class Venues(@SerializedName("venues") val venues: List<VenueData>?)

data class VenueData(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("contact") val contact: VenueContact?,
    @SerializedName("location") val location: VenueLocation?,
    @SerializedName("hours") val hours: List<VenueHourData>?
)

data class VenueContact(
    @SerializedName("phone") val phone: String?,
    @SerializedName("formattedPhone") val formattedPhone: String?
)

data class VenueLocation(
    @SerializedName("lat") val lat: Double?,
    @SerializedName("lng") val lng: Double?,
    @SerializedName("distance") val distance: Int?,
    @SerializedName("formattedAddress") val formattedAddress: List<String>?,
    @SerializedName("address") val address: String?,
    @SerializedName("city") val city: String?,
    @SerializedName("state") val state: String?,
    @SerializedName("postalCode") val postalCode: String?
)


data class VenueHourData(
    @SerializedName("days") val days: List<Int>?,
    @SerializedName("includesToday") val includesToday: Boolean?,
    @SerializedName("open") val open: List<VenueHourOpenData>?
)

data class VenueHourOpenData(
    @SerializedName("start") val start: String?,
    @SerializedName("end") val end: String?
)