package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

/**
 * 11/17/18.
 */
data class MapboxGeocode(
    @SerializedName("type") val type: String?,
    @SerializedName("query") val query: List<Double>?,
    @SerializedName("features") val features: List<MapboxFeature>?,
    @SerializedName("attribution") val attribution: String?
)

data class ReverseGeoCode(@SerializedName("features") val features: List<MapboxFeature>?)

data class MapboxFeature(
    @SerializedName("id") val id: String?,
    @SerializedName("type") val type: String?,
    @SerializedName("place_type") val placeType: List<String>?,
    @SerializedName("relevance") val relevance: Int?,
    @SerializedName("text") val text: String?,
    @SerializedName("place_name") val placeName: String?,
    @SerializedName("center") val center: List<Double>?,
    @SerializedName("geometry") val geometry: MapboxGeometry?,
    @SerializedName("address") val address: String?,
    @SerializedName("context") val featureContext: List<MapboxContext>?
)

data class MapboxGeometry(
    @SerializedName("type") val type: String?,
    @SerializedName("coordinates") val coordinates: List<Double>?
)

data class MapboxContext(
    @SerializedName("id") val id: String?,
    @SerializedName("wikidata") val wikidata: String?,
    @SerializedName("short_code") val shortCode: String?,
    @SerializedName("text") val text: String?
)