package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 12/29/18.
 */
data class Badges(@SerializedName("badges") val badges: List<BadgesItem>?)

data class BadgesItem(
    @SerializedName("name") val name: String?,
    @SerializedName("iconUrl") val iconUrl: String?,
    @SerializedName("count") val count: Int?,
    @SerializedName("description") val description: String?
)

data class TripBadges(
    @SerializedName("badges") val badges: List<TripBadgeItem>?,
    @SerializedName("meta") val meta: Meta?
)

data class TripBadgeItem(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("iconUrl") val iconUrl: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("tripId") val tripId: String?,
    @SerializedName("vehicleId") val vehicleId: String?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?
)

/***
 * Device Badges
{
"badges": [
{
"name": "granny",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/granny.png",
"count": 213,
"description": "Your average trip speed was slow."
},
{
"name": "terrible driver",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/worst-driver.png",
"count": 9,
"description": "It looks like this was a rough ride..."
},
{
"name": "speed demon",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/speed-demon.png",
"count": 174,
"description": "Your average trip speed was fast."
},
{
"name": "traveler",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/traveler.png",
"count": 6,
"description": "This was a long trip!"
},
{
"name": "polluter",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/polluter.png",
"count": 704,
"description": "Your fuel efficiency wasn't very good on this trip."
}
]
}

Trip Badges
{
"badges": [
{
"id": "f2c67bcb-d65d-4448-8306-3fad600dfb04",
"name": "tree hugger",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/tree-hugger.png",
"deviceId": "55d4caa0-a179-486b-ba8e-75c4c0678a79",
"tripId": "8c0f978e-17d4-4365-b3dd-7f8613f799a0",
"vehicleId": "328c47af-d542-4845-9f67-a13784ca2270",
"createdAt": "2018-12-29T01:53:08.61466Z",
"updatedAt": "2018-12-29T01:53:08.61466Z"
},
{
"id": "eec6f320-44ef-4dc7-8d32-33cdd4eca693",
"name": "speed demon",
"iconUrl": "https://s3.amazonaws.com/vinli-public/badge-service/speed-demon.png",
"deviceId": "55d4caa0-a179-486b-ba8e-75c4c0678a79",
"tripId": "8c0f978e-17d4-4365-b3dd-7f8613f799a0",
"vehicleId": "328c47af-d542-4845-9f67-a13784ca2270",
"createdAt": "2018-12-29T01:53:08.611968Z",
"updatedAt": "2018-12-29T01:53:08.611968Z"
}
],
"meta": {
"pagination": {
"total": 2,
"limit": 20,
"offset": 0,
"links": {
"first": "https://my-vinli.vin.li/api/v1/_internal/trips/8c0f978e-17d4-4365-b3dd-7f8613f799a0/badges?limit=20&offset=0",
"last": "https://my-vinli.vin.li/api/v1/_internal/trips/8c0f978e-17d4-4365-b3dd-7f8613f799a0/badges?limit=20&offset=0"
}
}
}
}
 **/