package li.vin.my.apikit.models

import java.util.*

enum class ReportPeriod constructor(val value: String) {
    DAILY("daily"),
    WEEKLY("weekly"),
    MONTHLY("monthly");

    companion object {

        private val map = HashMap<String, ReportPeriod>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): ReportPeriod {
            return map[value]!!
        }
    }
}
