/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit.network;

import com.google.gson.Gson;
import io.sentry.Sentry;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.ApiKit;
import li.vin.my.apikit.AuthSettings;
import li.vin.my.apikit.errors.ConflictException;
import li.vin.my.apikit.errors.DataNotFoundException;
import li.vin.my.apikit.errors.ErrorMessage;
import li.vin.my.apikit.errors.GenericError;
import li.vin.my.apikit.errors.GenericErrorException;
import li.vin.my.apikit.network.BaseResponseHandler;
import li.vin.my.apikit.network.BaseServiceKt;
import li.vin.my.apikit.network.GsonConverter;
import li.vin.my.apikit.network.Poolable;
import li.vin.my.apikit.network.Queueable;
import li.vin.my.apikit.network.ReceivedCookiesInterceptor;
import li.vin.my.apikit.network.ResponseHandler;
import li.vin.my.apikit.network.ServicePool;
import li.vin.my.apikit.network.ServiceQueue;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020+H$J'\u0010.\u001a\u0002H/\"\u0004\b\u0001\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/012\u0006\u00102\u001a\u00020\u000e\u00a2\u0006\u0002\u00103J/\u0010.\u001a\u0002H/\"\u0004\b\u0001\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/012\u0006\u00102\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000e\u00a2\u0006\u0002\u00105J\u0006\u00106\u001a\u00020+J\b\u00107\u001a\u00020+H\u0016J\u0006\u00108\u001a\u00020\u000eJ\u0006\u00109\u001a\u00020\u000eJ\u0006\u0010:\u001a\u00020\u000eJ\u0006\u0010;\u001a\u00020\u000eJ\u0014\u0010<\u001a\u00020\u000e2\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>J\u0014\u0010?\u001a\u00020\u000e2\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>J\u0006\u0010@\u001a\u00020\u000eJ\u0016\u0010A\u001a\u00020+2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000BH\u0002J\u0014\u0010C\u001a\u00020+2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000BJ\u001c\u0010D\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000BJ\u0010\u0010E\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010F\u001a\u00020+H\u0002J\u0018\u0010G\u001a\u00020+2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lli/vin/my/apikit/network/BaseService;", "Pojo", "Lli/vin/my/apikit/network/Queueable;", "Lli/vin/my/apikit/network/Poolable;", "()V", "call", "Lretrofit2/Call;", "getCall", "()Lretrofit2/Call;", "setCall", "(Lretrofit2/Call;)V", "dedupe", "", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "isCanceled", "()Z", "setCanceled", "(Z)V", "poolId", "getPoolId", "queuePosition", "", "responseHandler", "Lli/vin/my/apikit/network/BaseResponseHandler;", "getResponseHandler", "()Lli/vin/my/apikit/network/BaseResponseHandler;", "setResponseHandler", "(Lli/vin/my/apikit/network/BaseResponseHandler;)V", "result", "Ljava/lang/Object;", "serviceQueue", "Lli/vin/my/apikit/network/ServiceQueue;", "successful", "getSuccessful", "setSuccessful", "throwable", "", "completed", "", "poolable", "createCall", "createService", "T", "serviceClass", "Ljava/lang/Class;", "baseUrl", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "authToken", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "endService", "execute", "getAuthToken", "getCookies", "getDeviceId", "getDriverId", "getErrorMessage", "response", "Lretrofit2/Response;", "getErrorMessageFor400", "getVehicleId", "makeCall", "Lli/vin/my/apikit/network/ResponseHandler;", "requestData", "requestNoDedupeData", "setBaseResponseHandler", "startService", "startServiceInQueue", "apikit_release"})
public abstract class BaseService<Pojo>
implements Queueable,
Poolable {
    @Nullable
    private Call<Pojo> call;
    private boolean dedupe;
    @NotNull
    private String id = "";
    @Nullable
    private BaseResponseHandler responseHandler;
    private ServiceQueue serviceQueue;
    private int queuePosition;
    private Pojo result;
    private Throwable throwable;
    private boolean isCanceled;
    private boolean successful;

    @Nullable
    public final Call<Pojo> getCall() {
        return this.call;
    }

    public final void setCall(@Nullable Call<Pojo> call) {
        this.call = call;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.id = string;
    }

    protected abstract void createCall();

    @Nullable
    public final BaseResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public final void setResponseHandler(@Nullable BaseResponseHandler baseResponseHandler) {
        this.responseHandler = baseResponseHandler;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean bl) {
        this.isCanceled = bl;
    }

    public final boolean getSuccessful() {
        return this.successful;
    }

    public final void setSuccessful(boolean bl) {
        this.successful = bl;
    }

    public final void requestData(@NotNull ResponseHandler<? super Pojo> responseHandler) {
        Intrinsics.checkParameterIsNotNull(responseHandler, (String)"responseHandler");
        this.dedupe = false;
        this.makeCall(responseHandler);
    }

    public final void requestNoDedupeData(@NotNull String id, @NotNull ResponseHandler<? super Pojo> responseHandler) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(responseHandler, (String)"responseHandler");
        this.dedupe = true;
        this.id = id;
        this.makeCall(responseHandler);
    }

    private final void makeCall(ResponseHandler<? super Pojo> responseHandler) {
        this.responseHandler = responseHandler;
        this.createCall();
        if (!this.isCanceled()) {
            ServicePool.INSTANCE.enter(this);
        }
    }

    @NotNull
    public final String getDeviceId() {
        return AuthSettings.Companion.getInstance().getDeviceId();
    }

    @NotNull
    public final String getDriverId() {
        return AuthSettings.Companion.getInstance().getDriverId();
    }

    @NotNull
    public final String getVehicleId() {
        return AuthSettings.Companion.getInstance().getVehicleId();
    }

    @NotNull
    public final String getCookies() {
        return AuthSettings.Companion.getInstance().getSessionId();
    }

    @NotNull
    public final String getAuthToken() {
        return AuthSettings.Companion.getInstance().getAuthToken();
    }

    private final void startService() {
        block0: {
            Call call = this.call;
            if (call == null || (call = call.clone()) == null) break block0;
            call.enqueue(new Callback<Pojo>(this){
                final /* synthetic */ BaseService this$0;

                /*
                 * Unable to fully structure code
                 */
                public void onResponse(@NotNull Call<Pojo> call, @NotNull Response<Pojo> response) {
                    block8: {
                        block9: {
                            block7: {
                                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                                if (!response.isSuccessful()) break block7;
                                this.this$0.setSuccessful(true);
                                BaseService.access$setResult$p(this.this$0, response.body());
                                break block8;
                            }
                            if (response.code() != 409) break block9;
                            this.this$0.setSuccessful(false);
                            BaseService.access$setThrowable$p(this.this$0, new ConflictException());
                            break block8;
                        }
                        if (response.body() == null) ** GOTO lbl-1000
                        if (response.body() instanceof List) {
                            v0 = response.body();
                            if (v0 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                            }
                            ** if (((List)v0).size() != 0) goto lbl-1000
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 2 sources

                        {
                            this.this$0.setSuccessful(false);
                            try {
                                BaseService.access$setThrowable$p(this.this$0, new DataNotFoundException(this.this$0.getErrorMessage(response)));
                            }
                            catch (Exception e) {
                                BaseService.access$setThrowable$p(this.this$0, new DataNotFoundException(""));
                            }
                            ** GOTO lbl31
                        }
lbl-1000:
                        // 2 sources

                        {
                            if (response.code() != 200) {
                                BaseService.access$setThrowable$p(this.this$0, new GenericErrorException(this.this$0.getErrorMessage(response)));
                                this.this$0.setSuccessful(false);
                            }
                        }
                    }
                    ServicePool.INSTANCE.leave(this.this$0);
                    this.this$0.endService();
                }

                public void onFailure(@NotNull Call<Pojo> call, @NotNull Throwable t) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    Sentry.capture((String)("API Failure: " + t.getMessage()));
                    this.this$0.setSuccessful(false);
                    BaseService.access$setThrowable$p(this.this$0, new Exception(t));
                    ServicePool.INSTANCE.leave(this.this$0);
                    this.this$0.endService();
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    public final void endService() {
        block10: {
            block9: {
                if (this.serviceQueue != null) {
                    if (this.successful) {
                        ServiceQueue serviceQueue = this.serviceQueue;
                        if (serviceQueue != null) {
                            Pojo Pojo = this.result;
                            if (Pojo == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
                            }
                            serviceQueue.serviceCompleted(Pojo, this.queuePosition);
                        }
                    } else {
                        Throwable throwable = this.throwable;
                        if (throwable != null) {
                            Throwable throwable2 = throwable;
                            boolean bl = false;
                            boolean bl2 = false;
                            Throwable it = throwable2;
                            boolean bl3 = false;
                            ServiceQueue serviceQueue = this.serviceQueue;
                            if (serviceQueue != null) {
                                serviceQueue.serviceError(it);
                            }
                        }
                    }
                    return;
                }
                if (!this.successful) break block9;
                BaseResponseHandler baseResponseHandler = this.responseHandler;
                if (baseResponseHandler == null) {
                    throw new TypeCastException("null cannot be cast to non-null type li.vin.my.apikit.network.ResponseHandler<Pojo>");
                }
                ((ResponseHandler)baseResponseHandler).onSuccess(this.result);
                break block10;
            }
            Throwable throwable = this.throwable;
            if (throwable == null) break block10;
            Throwable throwable3 = throwable;
            boolean bl = false;
            boolean bl4 = false;
            Throwable it = throwable3;
            boolean bl5 = false;
            BaseResponseHandler baseResponseHandler = this.responseHandler;
            if (baseResponseHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type li.vin.my.apikit.network.ResponseHandler<Pojo>");
            }
            ((ResponseHandler)baseResponseHandler).onError(it);
        }
    }

    @NotNull
    public final String getErrorMessage(@NotNull Response<Pojo> response) {
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        String errorMessage = "";
        if (response.errorBody() != null) {
            Gson gson = new Gson();
            ResponseBody responseBody = response.errorBody();
            GenericError genericError = (GenericError)gson.fromJson(responseBody != null ? responseBody.string() : null, GenericError.class);
            errorMessage = genericError.getMessage();
        }
        CharSequence charSequence = errorMessage;
        boolean bl = false;
        return charSequence.length() == 0 ? GenericError.Companion.getErrorMessage(response.code()) : errorMessage;
    }

    @NotNull
    public final String getErrorMessageFor400(@NotNull Response<Pojo> response) {
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        String errorMessage = "";
        if (response.errorBody() != null) {
            Gson gson = new Gson();
            ResponseBody responseBody = response.errorBody();
            ErrorMessage genericError = (ErrorMessage)gson.fromJson(responseBody != null ? responseBody.string() : null, ErrorMessage.class);
            errorMessage = genericError.getMessage();
        }
        return errorMessage;
    }

    public final <T> T createService(@NotNull Class<T> serviceClass, @NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        return (T)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GsonConverter.INSTANCE.getGsonConverter())).client(ApiKit.Companion.getOkHttpClient()).build().create(serviceClass);
    }

    public final <T> T createService(@NotNull Class<T> serviceClass, @NotNull String baseUrl, @NotNull String authToken) {
        Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        if (Intrinsics.areEqual((Object)AuthSettings.Companion.getInstance().getAuthToken(), (Object)"Bearer") ^ true) {
            BaseServiceKt.getHttpBuilder(okHttpClientBuilder, authToken);
        }
        long cacheSize = 0xA00000L;
        Cache cacheDir = new Cache(ApiKit.Companion.getInstance().getCacheDir(), cacheSize);
        okHttpClientBuilder.cache(cacheDir);
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null);
        logging.level(ApiKit.Companion.getDebugLogging() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.BASIC);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        okHttpClientBuilder.addInterceptor((Interceptor)new ReceivedCookiesInterceptor());
        okHttpClientBuilder.connectTimeout(45L, TimeUnit.SECONDS);
        okHttpClientBuilder.readTimeout(45L, TimeUnit.SECONDS);
        return (T)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GsonConverter.INSTANCE.getGsonConverter())).client(okHttpClientBuilder.build()).build().create(serviceClass);
    }

    @Override
    public void startServiceInQueue(@NotNull ServiceQueue serviceQueue, int queuePosition) {
        Intrinsics.checkParameterIsNotNull((Object)serviceQueue, (String)"serviceQueue");
        this.serviceQueue = serviceQueue;
        this.queuePosition = queuePosition;
        this.createCall();
        if (!this.isCanceled()) {
            ServicePool.INSTANCE.enter(this);
        }
    }

    @Override
    public void setBaseResponseHandler(@NotNull BaseResponseHandler responseHandler) {
        Intrinsics.checkParameterIsNotNull((Object)responseHandler, (String)"responseHandler");
        this.responseHandler = responseHandler;
    }

    @Override
    public void execute() {
        this.startService();
    }

    @Override
    public void completed(@NotNull Poolable poolable) {
        Intrinsics.checkParameterIsNotNull((Object)poolable, (String)"poolable");
        if (poolable instanceof BaseService) {
            Pojo duplicate;
            Pojo Pojo = duplicate = ((BaseService)poolable).result;
            if (Pojo != null) {
                Pojo Pojo2 = Pojo;
                boolean bl = false;
                boolean bl2 = false;
                Pojo it = Pojo2;
                boolean bl3 = false;
                this.successful = true;
                this.result = duplicate;
                this.endService();
                return;
            }
            Throwable throwable = ((BaseService)poolable).throwable;
            boolean bl = false;
            boolean bl4 = false;
            Throwable it = throwable;
            boolean bl5 = false;
            this.successful = false;
            this.throwable = it;
            this.endService();
        }
    }

    @Override
    @NotNull
    public String getPoolId() {
        Request request;
        Request request2;
        return this.dedupe ? String.valueOf((request2 = this.call) != null && (request2 = request2.request()) != null ? request2.url() : null) + this.id : String.valueOf((request = this.call) != null && (request = request.request()) != null ? request.url() : null);
    }

    public static final /* synthetic */ Object access$getResult$p(BaseService $this) {
        return $this.result;
    }

    public static final /* synthetic */ void access$setResult$p(BaseService $this, Object object) {
        $this.result = object;
    }

    public static final /* synthetic */ Throwable access$getThrowable$p(BaseService $this) {
        return $this.throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(BaseService $this, Throwable throwable) {
        $this.throwable = throwable;
    }
}

