package li.vin.my.apikit.services

import li.vin.my.apikit.api.VenuesAPI
import li.vin.my.apikit.models.Venues
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 1/18/19.
 */
class VenuesService(val providerID: String, val lat: Double, val lng: Double) : BaseService<Venues>() {

    override fun createCall() {
        val request = createService(VenuesAPI::class.java, Endpoints.getAuthBaseUrl())
        val coordinates = listOf(lat, lng)
        call = request.getVenues(coordinates.toString(), "towing", 25000, providerID, getCookies())
    }
}