package li.vin.my.apikit.services

import li.vin.my.apikit.api.ServiceProviderAPI
import li.vin.my.apikit.models.ServiceProvider
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 1/4/19.
 */
class ServiceProviderService(val lat: Double, val lon: Double) : BaseService<ServiceProvider>() {

    override fun createCall() {
        val request = createService(ServiceProviderAPI::class.java, Endpoints.getVinliBaseUrl())
        val pathParam = lon.toString() + "," + lat.toString()
        call = request.getServiceProviders(getDeviceId(), pathParam)
    }
}