package li.vin.my.apikit.services

import android.graphics.Bitmap
import li.vin.my.apikit.api.DeviceAPI
import li.vin.my.apikit.models.Device
import li.vin.my.apikit.models.DriverDevice
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints
import li.vin.my.apikit.network.getImageString

class DeviceIconUpdateService(val icon: Bitmap?) : BaseService<DriverDevice>() {

    override fun createCall() {
        val request = createService(DeviceAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.updateIcon(getDriverId(), getDeviceId(), getImageString(icon), getCookies()
        )
    }


}