package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/5/18.
 */
data class Vehicle(
    @SerializedName("devices") val devices: List<VehicleDevices>?,
    @SerializedName("meta") val meta: Meta?
)

data class VehicleDevices(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("icon") val icon: String?, //Unknown value so it is Object for now...
    @SerializedName("createAt") val createAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?,
    @SerializedName("caseId") val caseId: String?,
    @SerializedName("chipId") val chipId: String?,
    @SerializedName("providerId") val providerId: String?,
    @SerializedName("dataPlanId") val dataPlanId: Any?,
    @SerializedName("nextDataPlanId") val nextDataPlanId: Any?,
    @SerializedName("nextBillingAt") val nextBillingAt: Any?,
    @SerializedName("trialPlanId") val trialPlanId: Any?,
    @SerializedName("trialEndsAt") val trialEndsAt: Any?,
    @SerializedName("links") val links: VehicleLinks?,
    @SerializedName("latestVehicle") val latestVehicle: LatestVehicle?,
    @SerializedName("latestLocation") val latestLocation: DeviceLatestLocation?
)

data class LatestVehicle(
    @SerializedName("id") val id: String?,
    @SerializedName("vin") val vin: String?,
    @SerializedName("make") val make: String?,
    @SerializedName("model") val model: String?,
    @SerializedName("year") val year: String?,
    @SerializedName("trim") val trim: String?,
    @SerializedName("metadata") val metadata: String?,
    @SerializedName("lastStartup") val lastStartup: Any?,
    @SerializedName("infoUpdatedAt") val infoUpdatedAt: Date?,
    @SerializedName("orgId") val orgId: String?,
    @SerializedName("infoUpdateStatus") val infoUpdateStatus: String?,
    @SerializedName("source") val source: String?,
    @SerializedName("createAt") val createAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?
)

data class VehicleLinks(
    @SerializedName("contacts") val contacts: String?,
    @SerializedName("wifiSetting") val wifiSetting: String?,
    @SerializedName("wifiUsage") val wifiUsage: String?
)
/**
{
"devices": [
{
"id": "157e0475-e3d1-43fb-bd0a-bbedea515524",
"name": "VirtualVinli",
"icon": null,
"createAt": "2018-06-04T18: 17:30.883Z",
"updatedAt": "2018-10-25T22: 47:19.630Z",
"caseId": "VVVBVJM",
"chipId": "VV79CBF33072",
"providerId": "953bf983-481f-4b96-b56e-62fb1863801f",
"dataPlanId": null,
"nextDataPlanId": null,
"nextBillingAt": null,
"trialPlanId": null,
"trialEndsAt": null,
"links": {
"contacts": "/api/v1/devices/157e0475-e3d1-43fb-bd0a-bbedea515524/contacts",
"wifiSetting": "/api/v1/wifiSettings/157e0475-e3d1-43fb-bd0a-bbedea515524",
"wifiUsage": "/api/v1/devices/157e0475-e3d1-43fb-bd0a-bbedea515524/wifiUsage"
},
"latestVehicle": {
"id": "471a4bcf-c3b5-439a-b2bd-b69149c94ac4",
"vin": "VVDGZSESKEK4PUVK6",
"make": "VirtualVinli",
"model": "DeLoreanDMC-12",
"year": "1982",
"trim": "2drCoupé",
"lastStartup": null,
"metadata": "{}",
"infoUpdatedAt": "2017-09-21T19: 35:13.652Z",
"infoUpdateStatus": "success",
"createdAt": "2017-09-21T19: 35:08.765Z",
"updatedAt": "2017-09-21T19: 35:13.650Z"
}
}
],
"meta": {
"pagination": {
"total": 1
}
}
}
 */