package li.vin.my.apikit.api

import li.vin.my.apikit.models.*
import retrofit2.Call
import retrofit2.http.*

/**
 * 12/11/18.
 */
interface DeviceAPI {

    @GET("/api/v1/devices")
    fun getDevices(@Header("Cookie") sessionCookie: String): Call<Vehicle>

    @GET("/api/v1/drivers/{driverId}/devices")
    fun getDriverDevices(@Header("Cookie") sessionCookie: String,
                         @Path("driverId") driverId: String): Call<DriverDevices>

    @GET("/api/v1/devices/{deviceId}")
    fun getDeviceDetails(
        @Path("deviceId") deviceId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Device>

    @Multipart
    @POST("/api/v1/devices")
    fun createDevice(
        @Part("device[name]") name: String,
        @Part("device[iconImage]") iconImage: String, @Part("device[caseId]") caseId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Device>

    @Multipart
    @PUT("/api/v1/drivers/{driverId}/driverDevice/{deviceId}/icon")
    fun updateIcon(
        @Path("driverId") driverId: String,
        @Path("deviceId") deviceId: String,
        @Part("driverDevice[iconImage]") iconImage: String,
        @Header("Cookie") sessionCookie: String
    ): Call<DriverDevice>

    @Multipart
    @PUT("/api/v1/devices/{deviceId}")
    fun updateDevice(
        @Path("deviceId") deviceId: String,
        @Part("device[name]") name: String, @Part("device[iconImage]") iconImage: String,
        @Part("device[caseId]") caseId: String, @Header("Cookie") sessionCookie: String
    ): Call<Device>

    @DELETE("/api/v1/devices/{deviceId}")
    fun deleteDevice(
        @Path("deviceId") deviceId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>

    @POST("/api/v1/devices/{deviceId}/replacements")
    fun replaceDevice(
        @Body caseId: CaseId, @Path("deviceId") deviceId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>

    @GET("/api/v1/cases/{caseId}/claimed")
    fun getCaseClaimed(@Path("caseId") caseId: String): Call<Claimed>
}