package li.vin.my.apikit.api

import li.vin.my.apikit.models.Telemetry
import li.vin.my.apikit.models.TelemetryLocations
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * 11/5/18.
 */
interface TelemetryAPI {
    @GET("/api/v1/devices/{deviceId}/snapshots")
    fun getTelemetryDeprecated(
        @Path("deviceId") deviceId: String,
        @Query("fields") fields: String,
        @Query("limit") limits: Int
    ): Call<Telemetry>

    @GET("/api/v1/drivers/{driverId}/vehicles/{vehicleId}/snapshots")
    fun getTelemetry(
        @Path("driverId") driverId: String,
        @Path("vehicleId") vehicleId: String,
        @Query("fields") fields: Array<String?>,
        @Query("limit") limits: Int,
        @Header("Authorization") auth: String
    ): Call<Telemetry>

    @GET("/api/v1/devices/{deviceId}/locations")
    fun getTelemetryLocations(
        @Path("deviceId") deviceId: String,
        @Query("limit") limit: Int
    ): Call<TelemetryLocations>
}