package li.vin.my.apikit.api

import li.vin.my.apikit.models.EmailPost
import li.vin.my.apikit.models.ForgotPassword
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.POST
import retrofit2.http.Query

interface ForgotPasswordAPI {

    @POST("/api/v1/forgotPassword")
    fun postForgotPassword(
            @Query("theme") theme: String,
            @Body emailWrapper: EmailPost): Call<Void>

    @POST("/api/v1/resetPassword")
    fun postResetPassword(
            @Query("theme") theme: String,
            @Body emailWrapper: ForgotPassword): Call<Void>
}