package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 12/9/18.
 */
data class TermsList(@SerializedName("terms") val terms: List<TermsData>?)

data class TermsData(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: TermsType?
)

data class TermsItem(@SerializedName("terms") val terms: Term?)

data class Term(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?,
    @SerializedName("version") val version: String?,
    @SerializedName("versionId") val versionId: String?,
    @SerializedName("text") val text: String?,
    @SerializedName("effectiveDate") val effectiveDate: Date?,
    @SerializedName("versions") val versions: List<String>?
)

data class TermsAgreements(@SerializedName("agreements") val agreements: List<TermsAgreementsData>?)

data class TermsPostAgreements(@SerializedName("agreement") val agreements: TermsPostAgreementsData?)

data class TermsAgreementsData(
    @SerializedName("termId") val termId: String?,
    @SerializedName("versionId") val versionId: String?,
    @SerializedName("version") val version: String?,
    @SerializedName("effectiveDate") val effectiveDate: String?
)

data class TermsPostAgreementsData(@SerializedName("versionId") val versionId: String?)

enum class TermsType constructor(val value: String) {

    T_MOBILE("T-Mobile®"),
    VINLI_PRIVACY("vinli-privacy"),
    WEBSITE("vinli-website-terms-of-use"),
    DEV_AGREEMENT("vinli-developer-agreement"),
    VINLI_MAIN("vinli-main");

    companion object {

        private val map = HashMap<String, TermsType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): TermsType {
            return map[value]!!
        }
    }
}