/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit.services;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.api.MapboxPlacesAPI;
import li.vin.my.apikit.models.MapboxGeocode;
import li.vin.my.apikit.network.BaseService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lli/vin/my/apikit/services/MapboxPlacesService;", "Lli/vin/my/apikit/network/BaseService;", "Lli/vin/my/apikit/models/MapboxGeocode;", "coordinates", "", "", "mapboxToken", "", "(Ljava/util/List;Ljava/lang/String;)V", "getCoordinates", "()Ljava/util/List;", "getMapboxToken", "()Ljava/lang/String;", "createCall", "", "apikit_release"})
public final class MapboxPlacesService
extends BaseService<MapboxGeocode> {
    @NotNull
    private final List<Double> coordinates;
    @NotNull
    private final String mapboxToken;

    @Override
    protected void createCall() {
        MapboxPlacesAPI request = this.createService(MapboxPlacesAPI.class, "https://api.mapbox.com");
        String coordinateString = String.valueOf(((Number)this.coordinates.get(0)).doubleValue()) + "," + String.valueOf(((Number)this.coordinates.get(1)).doubleValue());
        this.setCall(request.geocode(coordinateString, "address,neighborhood,locality,place,region,country", this.mapboxToken));
    }

    @NotNull
    public final List<Double> getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final String getMapboxToken() {
        return this.mapboxToken;
    }

    public MapboxPlacesService(@NotNull List<Double> coordinates, @NotNull String mapboxToken) {
        Intrinsics.checkParameterIsNotNull(coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)mapboxToken, (String)"mapboxToken");
        this.coordinates = coordinates;
        this.mapboxToken = mapboxToken;
    }
}

