package li.vin.my.apikit

import android.app.Application
import android.content.Context
import io.sentry.Sentry
import io.sentry.android.AndroidSentryClientFactory
import li.vin.my.apikit.network.ReceivedCookiesInterceptor
import okhttp3.Cache
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import java.io.File

class ApiKit private constructor(val context: Context, val baseUrl: String, val cacheDir: File) {

    companion object {
        private var apikit: ApiKit? = null
        val okHttpClientBuilder = OkHttpClient.Builder()
        lateinit var okHttpClient: OkHttpClient
        var debugLogging = false

        fun getInstance(application: Application): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(application.applicationContext, "vin.li", application.applicationContext.cacheDir)
                initializeOkHttp(application.applicationContext, application)
            }
            return apikit!!
        }

        fun getInstance(application: Application, baseUrl: String): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(application.applicationContext, baseUrl, application.applicationContext.cacheDir)
                initializeOkHttp(application.applicationContext, application)
            }
            return apikit!!
        }

        fun getInstance(application: Application, baseUrl: String, debugLogging: Boolean): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(application.applicationContext, baseUrl, application.applicationContext.cacheDir)
                this.debugLogging = debugLogging
                initializeOkHttp(application.applicationContext, application)
            }
            return apikit!!
        }

        fun getInstance(application: Application, baseUrl: String, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(application.applicationContext, baseUrl, cacheDir)
                initializeOkHttp(application.applicationContext, application)
            }
            return apikit!!
        }

        fun getInstance(application: Application, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(application.applicationContext, "vin.li", cacheDir)
                initializeOkHttp(application.applicationContext, application)
            }
            return apikit!!
        }

        private fun getAuthToken(): String {
            return AuthSettings.instance.getAuthToken()
        }

        private fun initializeOkHttp(context: Context, application: Application) {
            Sentry.init("https://74084de8fefb43b7803ab4a5b55474bb@sentry.io/1935791", AndroidSentryClientFactory(application))
            AuthSettings.getInstance(context)
            val cacheSize: Long = 10 * 1024 * 1024 // 10 MB
            val cacheDir = Cache(instance.cacheDir, cacheSize)
            okHttpClientBuilder.cache(cacheDir)
//            val logging = HttpLoggingInterceptor()
//            logging.level = if (debugLogging) HttpLoggingInterceptor.Level.BODY else HttpLoggingInterceptor.Level.BASIC
//            okHttpClientBuilder.addInterceptor(logging)
            okHttpClientBuilder.addInterceptor(ReceivedCookiesInterceptor())
            if (AuthSettings.instance.getAuthToken() != "Bearer") {
                okHttpClientBuilder.addInterceptor(Interceptor { chain ->
                    val original = chain.request()
                    val requestBuilder = original.newBuilder()
                        .header("Authorization", getAuthToken())
                        .method(original.method, original.body)
                    val request = requestBuilder.build()
                    chain.proceed(request)
                })
            }
            okHttpClient = okHttpClientBuilder.build()
        }

        val instance: ApiKit
            get() {
                if (apikit == null) {
                    throw IllegalStateException("Apikit context not set")
                }
                return apikit!!
            }
    }
}
