package li.vin.my.apikit.services

import li.vin.my.apikit.api.SessionAPI
import li.vin.my.apikit.models.Session
import li.vin.my.apikit.models.UserLogin
import li.vin.my.apikit.models.UserLoginData
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/10/18.
 */
class SessionCreateService(private val email: String, private val password: String) : BaseService<Session>() {

    override fun createCall() {
        val request = createService(SessionAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.createNewSession(UserLogin(UserLoginData(email, password)))
    }
}