package li.vin.my.apikit.services

import li.vin.my.apikit.api.ForgotPasswordAPI
import li.vin.my.apikit.models.EmailPost
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class ForgotPasswordService(val email: String): BaseService<Void>() {
    constructor(email: String, theme: String) : this(email) {
        this.theme = theme
    }
    // default to no theme
    var theme = ""

    override fun createCall() {
        val request = createService(ForgotPasswordAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.postForgotPassword(theme, EmailPost(email))
    }
}