package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 12/10/18.
 */
data class User(@SerializedName("user") val user: UserData?)

data class UserPost(@SerializedName("user") val user: UserPostData?)

data class UserLogin(@SerializedName("session") val session: UserLoginData?)

data class UserLoginData(
    @SerializedName("email") val email: String?,
    @SerializedName("password") val password: String?
)

data class UserData(
    @SerializedName("id") val id: String?,
    @SerializedName("firstName") val firstName: String?,
    @SerializedName("lastName") val lastName: String?,
    @SerializedName("email") val email: String?,
    @SerializedName("phone") val phone: String?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?,
    @SerializedName("settings") val settings: UserSettings?
)

data class UserPostData(
    @SerializedName("email") val email: String?,
    @SerializedName("firstName") val firstName: String?,
    @SerializedName("lastName") val lastName: String?,
    @SerializedName("password") val password: String?,
    @SerializedName("phone") val phone: String?,
    @SerializedName("settings") val settings: UserPostSettings?
)

data class UserSettings(
    @SerializedName("unit") val unit: String,
    @SerializedName("locale") val locale: String?,
    @SerializedName("country") val country: String?
)

data class UserPostSettings(@SerializedName("unit") val unit: String,
                            @SerializedName("country") val country: String?,
                            @SerializedName("locale") val locale: String?)