package li.vin.my.apikit.models

import java.util.HashMap

enum class ExportType constructor(val value: String) {

    PDF("pdf"),
    CSV("csv"),
    XLSX("xlsx");

    companion object {

        private val map = HashMap<String, ExportType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): ExportType {
            return map[value]!!
        }
    }
}