package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 1/7/19.
 */
data class Device(@SerializedName("device") val device: DeviceData?)

data class DeviceData(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("icon") val icon: String?,
    @SerializedName("createAt") val createAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?,
    @SerializedName("caseId") val caseId: String?,
    @SerializedName("chipId") val chipId: String?,
    @SerializedName("providerId") val providerId: String?,
    @SerializedName("dataPlanId") val dataPlanId: String?,
    @SerializedName("nextDataPlanId") val nextDataPlanId: String?,
    @SerializedName("nextBillingAt") val nextBillingAt: Date?,
    @SerializedName("trialPlanId") val trialPlanId: Date?,
    @SerializedName("trialEndsAt") val trialEndsAt: Date?,
    @SerializedName("links") val links: DeviceLinks?,
    @SerializedName("latestVehicle") val latestVehicle: DeviceLatestVehicle?,
    @SerializedName("latestLocation") val latestLocation: DeviceLatestLocation?,
    @SerializedName("latestMessageTime") val latestMessageTime: Date?
)

data class DeviceLinks(
    @SerializedName("contacts") val contacts: String?,
    @SerializedName("wifiSetting") val wifiSetting: String?,
    @SerializedName("wifiUsage") val wifiUsage: String?
)

data class DeviceLatestVehicle(
    @SerializedName("id") val id: String?,
    @SerializedName("vin") val vin: String?,
    @SerializedName("make") val make: String?,
    @SerializedName("model") val model: String?,
    @SerializedName("year") val year: String?,
    @SerializedName("trim") val trim: String?,
    @SerializedName("metadata") val metadata: String?,
    @SerializedName("lastStartup") val lastStartup: Any?,
    @SerializedName("infoUpdatedAt") val infoUpdatedAt: Date?,
    @SerializedName("infoUpdateStatus") val infoUpdateStatus: String?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?
)

data class DeviceLatestLocation(
    @SerializedName("type") val type: String?,
    @SerializedName("geometry") val geometry: FeatureGeometry?,
    @SerializedName("properties") val properties: FeatureProperties?
)

data class Claimed(@SerializedName("claimed") val claimed: Boolean)

data class CaseId(@SerializedName("caseId") val caseId: String) // ALL CAPS!
