package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/3/18.
 */
data class BatteryStatus(@SerializedName("batteryStatus") val batteryStatus: BatteryStatusData?)

data class BatteryStatusData(
    @SerializedName("status") val status: BatteryColor?,
    @SerializedName("timestamp") val timestamp: Date?
)

enum class BatteryColor constructor(val value: String) {

    GREEN("green"),
    YELLOW("yellow"),
    RED("red"),
    UNKNOWN("unknown");

    companion object {

        private val map = HashMap<String, BatteryColor>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): BatteryColor {
            return map[value]!!
        }
    }
}
/**
{
"batteryStatus": {
"status": "green",
"timestamp": "2018-11-05T14:40:07.000Z"
}
}
 */