package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/7/18.
 */
data class Trips(
    @SerializedName("trips") val trips: List<TripsData>?,
    @SerializedName("meta") val meta: Meta?
)

data class TripsData(
    @SerializedName("id") val id: String?,
    @SerializedName("start") val start: Date?,
    @SerializedName("stop") val stop: Date?,
    @SerializedName("status") val status: String?,
    @SerializedName("vehicleId") val vehicleId: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("startPoint") val startPoint: TripsPoint?,
    @SerializedName("stopPoint") val stopPoint: TripsPoint?,
    @SerializedName("preview") val preview: String?,
    @SerializedName("stats") val stats: TripsStats?,
    @SerializedName("grade") val grade: String?,
    @SerializedName("tags") val tags: List<TripsTags>?,
    @SerializedName("comment") val comment: TripComment,
    @SerializedName("meta") val meta: OdometerMeta?,
    @SerializedName("estimatedStart") val estimatedStart: TripsPoint?,
    @SerializedName("eventCounts") val eventCounts:EventCountsData?,
    @SerializedName("estimatedPolyline") val estimatedPolyline: String?,
    @SerializedName("startAddress") val startAddress: String?,
    @SerializedName("startAddressComponents") val startAddressComponents: List<String>?,
    @SerializedName("links") val links: TripsLinks?,
    @SerializedName("locations") val locations: TripLocationList?
)

data class TripsPoint(
    @SerializedName("type") val type: String?,
    @SerializedName("coordinates") val coordinates: List<Double>?
)

data class EventCountsData(@SerializedName("high-speed") val highSpeed: Int?,
                           @SerializedName("battery-level") val batteryLevel: Int?,
                           @SerializedName("shutdown") val shutdown: Int?,
                           @SerializedName("startup") val startup: Int,
                           @SerializedName("trip-stopped") val tripStopped: Int?,
                           @SerializedName("trip-completed") val tripCompleted: Int?,
                           @SerializedName("trip-orphaned") val tripOrphaned: Int?,
                           @SerializedName("trip-started") val tripStarted: Int?,
                           @SerializedName("hard-accel") val hardAccel: Int?,
                           @SerializedName("hard-decel") val hardDecel: Int?,
                           @SerializedName("over-revving") val overRevving: Int?,
                           @SerializedName("rule-enter") val ruleEnter: Int?,
                           @SerializedName("rule-leave") val ruleLeave: Int?,
                           @SerializedName("idling") val idling: Int?)

data class TripLocationList(
    @SerializedName("locations") val locations: List<TripLocations>?,
    @SerializedName("meta") val meta: Meta?
)

data class TripsStats(
    @SerializedName("averageLoad") val averageLoad: Double?,
    @SerializedName("averageMovingSpeed") val averageMovingSpeed: Double?,
    @SerializedName("averageSpeed") val averageSpeed: Double?,
    @SerializedName("comprehensiveLocations") val comprehensiveLocations: Boolean?,
    @SerializedName("distance") val distance: Double?,
    @SerializedName("distanceByGPS") val distanceByGPS: Double?,
    @SerializedName("distanceByVSS") val distanceByVSS: Double?,
    @SerializedName("duration") val duration: Long?,
    @SerializedName("fuelConsumed") val fuelConsumed: Double?,
    @SerializedName("fuelEconomy") val fuelEconomy: Double?,
    @SerializedName("hardAccelCount") val hardAccelCount: Int?,
    @SerializedName("hardBrakeCount") val hardBrakeCount: Int?,
    @SerializedName("locationCount") val locationCount: Int?,
    @SerializedName("maxSpeed") val maxSpeed: Double?,
    @SerializedName("messageCount") val messageCount: Int?,
    @SerializedName("stdDevMovingSpeed") val stdDevMovingSpeed: Double?,
    @SerializedName("stopCount") val stopCount: Int?,
    @SerializedName("substantial") val substantial: Boolean?
)

data class TripsLinks(
    @SerializedName("self") val self: String?,
    @SerializedName("device") val device: String?,
    @SerializedName("vehicle") val vehicle: String?,
    @SerializedName("locations") val locations: String?,
    @SerializedName("messages") val messages: String?,
    @SerializedName("events") val events: String?
)

data class TripsTags(
    @SerializedName("id") val id: String?,
    @SerializedName("tripId") val tripId: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("appMeta") val appMeta: TripsTagsMeta?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?
)

data class TripComment(
    @SerializedName("id") val id: String?,
    @SerializedName("tripId") val tripId: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?
)

data class TripLocations(
    @SerializedName("id") val id: String?,
    @SerializedName("timestamp") val timestamp: Date?,
    @SerializedName("data") val data: TripLocationsData?,
    @SerializedName("links") val links: TripsLinks?,
    @SerializedName("locationId") val locationId: String?,
    @SerializedName("coordinates") val coordinates: List<Double>?,
    @SerializedName("gasUsed") val gasUsed: Double?,
    @SerializedName("averageGasUsed") val averageGasUsed: Double?
)

data class TripLocationsData(
    @SerializedName("calculatedLoadValue") val calculatedLoadValue: Double?,
    @SerializedName("rpm") val rpm: Double?,
    @SerializedName("vehicleSpeed") val vehicleSpeed: Int?
)

data class TripsTagsMeta(
    @SerializedName("businessDistance") val businessDistance: String?,
    @SerializedName("personalDistance") val personalDistance: String?
)

data class OdometerMeta(@SerializedName("odometer") val odometer: Double?,
                        @SerializedName("previousOdometer") val previousOdometer: Double?,
                        @SerializedName("odometerDelta") val odometerDelta: Double?,
                        @SerializedName("odometerUpdated") val odometerUpdated: Boolean)

data class CreateTagsData(
    @SerializedName("tags") val tags: List<TripsTags>?,
    @SerializedName("meta") val meta: Meta?
)

data class UpdateTagData(@SerializedName("tag") val tags: TripsTags?)

data class TagPostBody(
    @SerializedName("tag") val tag: TripsTags?,
    @SerializedName("deviceId") val deviceId: String?
)

data class TagsPostBody(
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("tags") val tags: List<TripsTags>?
)


/**
{
"trips": [
{
"id": "a51a3c87-baa7-4e5d-98e6-4f9588d7c2e1",
"start": "2018-11-08T01:10:00.000Z",
"stop": "2018-11-08T01:24:51.000Z",
"status": "completed",
"vehicleId": "0c785aa0-1a48-4cc6-9f5c-028350dd907d",
"deviceId": "fe4bbc20-cc90-11e3-8e05-f3abac5b6b58",
"startPoint": {
"type": "Point",
"coordinates": [
-96.789843,
32.782253
]
},
"stopPoint": {
"type": "Point",
"coordinates": [
-96.686147,
32.8333
]
},
"preview": "icagEpqumQAEEWGWIYIUYm@s@yAUi@Oc@CGOm@Kg@GYUiACq@M_DMiD?GImBGmBQmFIoBEmAAKOyB[_BUcAY_ACIUo@]u@c@w@e@s@]c@[_@WUWUo@i@i@]i@[{CwAuCsA{BmAq@e@CAcAu@g@c@y@{@kAqAq@y@iBwBo@w@yBqCmBaCs@_A_AyAm@gAGKm@sA{@wBY}@YeAWgAG]Mk@SiAQiAMkAMeBCo@Aa@EcACoAEwBCsAEaCEiCS{LQeKGaDCuDE{BK}G??CaEAmA?m@CuLAsAAyEAkFIaO?KMiVAmBCoCCuE?WCyCCcBEmAIkA??KaAWcBQy@WgAW{@Yw@?A[s@]s@cCmEMU_@o@s@qA[s@Y}BIm@Gs@EcBAS?ICkA?GAi@SYw@cA_AmAACq@cAEEc@k@KOk@_Am@u@sAcBm@u@a@k@yC}DqBmC}B{CyBmCwBsCcAsAu@aAeC_DgCgDYa@_@c@U[u@cAoA_B]c@MOkAwAIIeAwAsBqCwBsCaC}CGIuBsCiCcDGGCE{GcJGIo@_Aw@iAqBcCo@{@EEs@{@wBoCa@g@m@w@]a@CC{@kAGMO[EIYg@MYk@{Ai@qBCMEUi@mCOu@UkAIYU{@EOw@yBa@cAO_@GOa@aAm@{AwBcF}AyDO]eAmCgAgC[s@yBkFGMCEEKMYY_AEO{@oBa@aAYq@KYu@cCEMMe@Qy@Kg@ESWgC_@aDg@mEGe@S_BY?I?cF?{CBQ?oA?]GOGSIWOKGYOy@W]Cy@As@AwEEm@AgBEyACeAE_BAcBCu@?q@?w@Jk@Ts@f@A@mAvAuAbBcD~DGHqBfC]e@QUmAoAs@u@UVsA|AaAdAe@d@[\\WN_@LU?[?k@SOOOWMUGQ[qAI[EM?A",
"stats": {
"averageLoad": 36.8365,
"averageMovingSpeed": 57.77,
"averageSpeed": 55.5481,
"comprehensiveLocations": true,
"distance": 13335.9,
"distanceByGPS": 13335.9,
"distanceByVSS": 11957,
"duration": 891000,
"fuelConsumed": 1.44099,
"fuelEconomy": 19.5175,
"hardAccelCount": 0,
"hardBrakeCount": 0,
"locationCount": 104,
"maxSpeed": 108,
"messageCount": 105,
"stdDevMovingSpeed": 24.5311,
"stopCount": 2,
"substantial": true
},
"links": {
"self": "https://trips.vin.li/api/v1/trips/a51a3c87-baa7-4e5d-98e6-4f9588d7c2e1",
"device": "https://platform.vin.li/api/v1/devices/fe4bbc20-cc90-11e3-8e05-f3abac5b6b58",
"vehicle": "https://platform.vin.li/api/v1/vehicles/0c785aa0-1a48-4cc6-9f5c-028350dd907d",
"locations": "https://telemetry.vin.li/api/v1/devices/fe4bbc20-cc90-11e3-8e05-f3abac5b6b58/locations?since=1440012315951&until=1440012928875",
"messages": "https://telemetry.vin.li/api/v1/devices/fe4bbc20-cc90-11e3-8e05-f3abac5b6b58/messages?since=1440012315951&until=1440012928875",
"events": "https://events.vin.li/api/v1/devices/fe4bbc20-cc90-11e3-8e05-f3abac5b6b58/events?since=1440012315951&until=1440012928875"
},
"grade": "A",
"tags": [
{
"id": "c2ff3992-5e8e-4fff-853b-d24bec4537e6",
"tripId": "fd87fec0-1177-4305-b461-650664061166",
"deviceId": "fe4bbc20-cc90-11e3-8e05-f3abac5b6b58",
"name": "business",
"appMeta": {
"businessDistance": "4972.25",
"personalDistance": "0"
},
"createdAt": "2018-11-20T21:41:09.79711Z",
"updatedAt": "2018-11-20T21:41:09.79711Z"
}
],
"comment": {
"id": "d37a802b-3f96-48b9-b91f-9265d19e5ded",
"tripId": "5c74a833-bb96-4065-876d-f812dbd3e102",
"deviceId": "dfa40a89-e383-4974-b363-0bf0ca1ab17b",
"description": "Hello!",
"createdAt": "2018-12-14T03:04:09.958357Z",
"updatedAt": "2018-12-14T03:04:09.958357Z"
}
"estimatedStart": {
"type": "Point",
"coordinates": [
-96.789845,
32.781981
]
},
"estimatedPolyline": "}vagE`hwmQN\\c@Jb@hDiARsCp@cDh@oCe@a@Gy@EaA?o@A_@FqAP]B_BBoCmDOUyDwEqCsD{CoDSWoCgDkEaGaBuBwAkBkDkEqBeCkBcCcEoFqAeBkBcCqDyEuAcB{D{Es@eAgFwGqIoKwBwCsDuE_D}DcDcEyD{EoCmDyByBwAsA}@aAc@a@}AeBsGmIeFsGaAgA_CaD",
"startAddress": "2222 Main St, Dallas, TX 75201, USA",
"startAddressComponents": [
"2222 Main St",
"Dallas",
"TX 75201",
"USA"
]
}
],
"meta": {
"pagination": {
"remaining": 476,
"until": "2018-11-08T02:07:00.278Z",
"since": "1970-01-01T00:00:00.000Z",
"limit": 1,
"sortDir": "desc",
"links": {
"prior": "https://trips-dev.vin.li/api/v1/devices/fe4bbc20-cc90-11e3-8e05-f3abac5b6b58/trips?until=1434129972999"
}
}
}
}
 */