package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/5/18.
 */
data class Distance(@SerializedName("distance") val distance: DistanceData?)

data class DistanceData(
    @SerializedName("vehicleId") val vehicleId: String?,
    @SerializedName("value") val value: Double?,
    @SerializedName("unit") val unit: String?,
    @SerializedName("confidenceMin") val confidenceMin: Double?,
    @SerializedName("confidenceMax") val confidenceMax: Double?,
    @SerializedName("lastOdometerDate") val lastOdometerDate: Date?,
    @SerializedName("links") val links: DistanceLinks?
)

data class DistanceLinks(
    @SerializedName("self") val self: String?,
    @SerializedName("vehicle") val vehicle: String?
)

/**
{
"distance": {
"vehicleId": "38ef2962-7fd2-4319-8389-f9a6b85a7e3f",
"value": 113833.191,
"unit": "km",
"confidenceMin": 113832.191,
"confidenceMax": 113834.191,
"lastOdometerDate": "2016-12-21T16:38:54.008Z",
"links": {
"self": "https://distance.vin.li/api/v1/vehicles/38ef2962-7fd2-4319-8389-f9a6b85a7e3f/distances/_latest?since=1970-01-01T00:00:00.000Z&until=2018-11-06T02:23:02.443Z",
"vehicle": "https://platform.vin.li/api/v1/vehicles/38ef2962-7fd2-4319-8389-f9a6b85a7e3f"
}
}
}
 */

enum class DistanceType constructor(private val type: String) {
    METERS("m"),
    KILOMETERS("km"),
    MILES("mi");

    override fun toString(): String {
        return type
    }
}