/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit;

import android.app.Application;
import android.content.Context;
import io.sentry.Sentry;
import io.sentry.SentryClientFactory;
import io.sentry.android.AndroidSentryClientFactory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.ApiKit;
import li.vin.my.apikit.AuthSettings;
import li.vin.my.apikit.network.ReceivedCookiesInterceptor;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lli/vin/my/apikit/ApiKit;", "", "context", "Landroid/content/Context;", "baseUrl", "", "cacheDir", "Ljava/io/File;", "(Landroid/content/Context;Ljava/lang/String;Ljava/io/File;)V", "getBaseUrl", "()Ljava/lang/String;", "getCacheDir", "()Ljava/io/File;", "getContext", "()Landroid/content/Context;", "Companion", "apikit_release"})
public final class ApiKit {
    @NotNull
    private final Context context;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final File cacheDir;
    private static ApiKit apikit;
    @NotNull
    private static final OkHttpClient.Builder okHttpClientBuilder;
    @NotNull
    public static OkHttpClient okHttpClient;
    private static boolean debugLogging;
    public static final Companion Companion;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final File getCacheDir() {
        return this.cacheDir;
    }

    private ApiKit(Context context, String baseUrl, File cacheDir) {
        this.context = context;
        this.baseUrl = baseUrl;
        this.cacheDir = cacheDir;
    }

    static {
        Companion = new Companion(null);
        okHttpClientBuilder = new OkHttpClient.Builder();
    }

    public /* synthetic */ ApiKit(Context context, String baseUrl, File cacheDir, DefaultConstructorMarker $constructor_marker) {
        this(context, baseUrl, cacheDir);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0019J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lli/vin/my/apikit/ApiKit$Companion;", "", "()V", "apikit", "Lli/vin/my/apikit/ApiKit;", "debugLogging", "", "getDebugLogging", "()Z", "setDebugLogging", "(Z)V", "instance", "getInstance", "()Lli/vin/my/apikit/ApiKit;", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "setOkHttpClient", "(Lokhttp3/OkHttpClient;)V", "okHttpClientBuilder", "Lokhttp3/OkHttpClient$Builder;", "getOkHttpClientBuilder", "()Lokhttp3/OkHttpClient$Builder;", "getAuthToken", "", "application", "Landroid/app/Application;", "cacheDir", "Ljava/io/File;", "baseUrl", "initializeOkHttp", "", "context", "Landroid/content/Context;", "apikit_release"})
    public static final class Companion {
        @NotNull
        public final OkHttpClient.Builder getOkHttpClientBuilder() {
            return okHttpClientBuilder;
        }

        @NotNull
        public final OkHttpClient getOkHttpClient() {
            OkHttpClient okHttpClient = okHttpClient;
            if (okHttpClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"okHttpClient");
            }
            return okHttpClient;
        }

        public final void setOkHttpClient(@NotNull OkHttpClient okHttpClient) {
            Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"<set-?>");
            ApiKit.okHttpClient = okHttpClient;
        }

        public final boolean getDebugLogging() {
            return debugLogging;
        }

        public final void setDebugLogging(boolean bl) {
            debugLogging = bl;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                File file = context2.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.applicationContext.cacheDir");
                apikit = new ApiKit(context, "vin.li", file, null);
                Context context3 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"application.applicationContext");
                this.initializeOkHttp(context3, application);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String baseUrl) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                File file = context2.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.applicationContext.cacheDir");
                apikit = new ApiKit(context, baseUrl, file, null);
                Context context3 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"application.applicationContext");
                this.initializeOkHttp(context3, application);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String baseUrl, boolean debugLogging) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                File file = context2.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.applicationContext.cacheDir");
                apikit = new ApiKit(context, baseUrl, file, null);
                this.setDebugLogging(debugLogging);
                Context context3 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"application.applicationContext");
                this.initializeOkHttp(context3, application);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String baseUrl, @NotNull File cacheDir) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                apikit = new ApiKit(context, baseUrl, cacheDir, null);
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                this.initializeOkHttp(context2, application);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull File cacheDir) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                apikit = new ApiKit(context, "vin.li", cacheDir, null);
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                this.initializeOkHttp(context2, application);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        private final String getAuthToken() {
            return AuthSettings.Companion.getInstance().getAuthToken();
        }

        private final void initializeOkHttp(Context context, Application application) {
            Sentry.init((String)"https://74084de8fefb43b7803ab4a5b55474bb@sentry.io/1935791", (SentryClientFactory)((SentryClientFactory)new AndroidSentryClientFactory(application)));
            AuthSettings.Companion.getInstance(context);
            long cacheSize = 0xA00000L;
            Cache cacheDir = new Cache(this.getInstance().getCacheDir(), cacheSize);
            this.getOkHttpClientBuilder().cache(cacheDir);
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(this.getDebugLogging() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.BASIC);
            this.getOkHttpClientBuilder().addInterceptor((Interceptor)logging);
            this.getOkHttpClientBuilder().addInterceptor((Interceptor)new ReceivedCookiesInterceptor());
            if (Intrinsics.areEqual((Object)AuthSettings.Companion.getInstance().getAuthToken(), (Object)"Bearer") ^ true) {
                this.getOkHttpClientBuilder().addInterceptor((Interceptor)initializeOkHttp.1.INSTANCE);
            }
            OkHttpClient okHttpClient = this.getOkHttpClientBuilder().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"okHttpClientBuilder.build()");
            this.setOkHttpClient(okHttpClient);
        }

        @NotNull
        public final ApiKit getInstance() {
            if (apikit == null) {
                throw (Throwable)new IllegalStateException("Apikit context not set");
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getAuthToken(Companion $this) {
            return $this.getAuthToken();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

