package li.vin.my.apikit.api

import li.vin.my.apikit.models.ContactWrapper
import li.vin.my.apikit.models.ContactsWrapper
import retrofit2.Call
import retrofit2.http.*

interface EmergencyContactsAPI {
    @GET("/api/v1/devices/{deviceId}/contacts")
    fun getContacts(
        @Path("deviceId") deviceId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<ContactsWrapper>

    @POST("/api/v1/contacts")
    fun createContact(
        @Body contact: ContactWrapper,
        @Header("Cookie") sessionCookie: String
    ): Call<ContactWrapper>

    @PUT("/api/v1/contacts/{contactId}")
    fun updateContact(
        @Body contact: ContactWrapper,
        @Path("contactId") contactId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>

    @DELETE("/api/v1/contacts/{contactId}")
    fun deleteContact(
        @Path("contactId") contactId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>

    @POST("/api/v1/contacts/{contactId}/tests")
    fun testContact(
        @Body contact: ContactWrapper,
        @Path("contactId") contactId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>
}