package li.vin.my.apikit.models

import java.util.*

/**
 * 1/14/19.
 */
enum class StationStatusType constructor(val value: Int) {

    DISCONNECTED(0),
    AVAILABLE(1),
    BUSY(2);

    companion object {

        private val map = HashMap<Int, StationStatusType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: Int): StationStatusType {
            return map[value]!!
        }
    }
}