package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

/**
 * 11/18/18.
 */
data class CatalogApps(@SerializedName("catalogApps") val catalogAppsData: List<CatalogAppsData>?)

data class CatalogAppsData(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("linkUrlWeb") val linkUrlWeb: String?,
    @SerializedName("linkUrlIos") val linkUrlIos: String?,
    @SerializedName("linkUrlAndroid") val linkUrlAndroid: String?,
    @SerializedName("iconUrl") val iconUrl: String?,
    @SerializedName("screenshotUrls") val screenshotUrls: String?,
    @SerializedName("category") val category: String?,
    @SerializedName("featured") val featured: Boolean?,
    @SerializedName("platform") val platform: String?,
    @SerializedName("liveRequired") val liveRequired: Boolean?,
    @SerializedName("featuredBannerUrl") val featuredBannerUrl: String?,
    @SerializedName("featuredMobileBannerUrl") val featuredMobileBannerUrl: String?,
    @SerializedName("rating") val rating: Double?,
    @SerializedName("comingSoon") val comingSoon: Boolean?,
    @SerializedName("ordinal") val ordinal: Int?
)

/**
{
"catalogApps": [
{
"id": "b75afd8f-7247-46e6-a0f9-04f187c9d9bd",
"name": "Beagle",
"description": "Keep your teen drivers safe with Beagle. Track their driving routes and speeds, and set up custom alerts to let you know when they stray from the straight and narrow.",
"linkUrlWeb": "",
"linkUrlIos": "https://itunes.apple.com/us/app/beagle-by-vinli/id1021395932?ls=1&mt=8",
"linkUrlAndroid": "https://play.google.com/store/apps/details?id=li.vin.beagleandroid",
"iconUrl": "https://s3.amazonaws.com/vinli-public/app-catalog/beagle/icon-beagle.png",
"screenshotUrls": "https://vinli-public.s3.amazonaws.com/app-catalog/beagle/dashboard.png,https://vinli-public.s3.amazonaws.com/app-catalog/beagle/dashboard-device-dropdown.png,https://vinli-public.s3.amazonaws.com/app-catalog/beagle/rule-00.png,https://vinli-public.s3.amazonaws.com/app-catalog/beagle/rule-01-boundary-dropdown.png,https://vinli-public.s3.amazonaws.com/app-catalog/beagle/rule-02-boundary.png,https://vinli-public.s3.amazonaws.com/app-catalog/beagle/rule-03-boundary-location.png,https://vinli-public.s3.amazonaws.com/app-catalog/beagle/rule-04-speed.png",
"category": "Safety",
"featured": true,
"platform": "ios,android",
"liveRequired": true,
"featuredBannerUrl": "{\"sm\": \"https://s3.amazonaws.com/vinli-public/app-catalog/beagle/beagle-featured-banner--sm.png\",\"md\": \"https://s3.amazonaws.com/vinli-public/app-catalog/beagle/beagle-featured-banner--md.png\",\"lg\": \"https://s3.amazonaws.com/vinli-public/app-catalog/beagle/beagle-featured-banner--lg.png\"}",
"featuredMobileBannerUrl": "https://vinli-public.s3.amazonaws.com/app-catalog/beagle/beagle-featured-mobile.png",
"rating": 5,
"comingSoon": false,
"ordinal": 0
},
{
"id": "c3868e00-24ea-11e4-899f-6b2dfb3a0b52",
"name": "Otto",
"description": "Let Otto diagnose your car's problems before they become problems. The app identifies issues, tells you how critical they are, and connects you to nearby mechanics to take care of them.",
"linkUrlWeb": null,
"linkUrlIos": null,
"linkUrlAndroid": null,
"iconUrl": "https://s3.amazonaws.com/vinli-public/app-catalog/otto/otto-launch-icon.png",
"screenshotUrls": "https://s3.amazonaws.com/vinli-public/app-catalog/otto/otto_1_loading.png,https://s3.amazonaws.com/vinli-public/app-catalog/otto/otto_4_diagnostics_large.png,https://s3.amazonaws.com/vinli-public/app-catalog/otto/otto_5_diagnostics_history.png,https://s3.amazonaws.com/vinli-public/app-catalog/otto/otto_6_settings_device.png",
"category": "Service",
"featured": false,
"platform": "android,web",
"liveRequired": false,
"featuredBannerUrl": null,
"featuredMobileBannerUrl": null,
"rating": 5,
"comingSoon": true,
"ordinal": 1006
}
]
}
 */