package li.vin.my.apikit.services

import li.vin.my.apikit.api.SecurityAPI
import li.vin.my.apikit.models.SecurityStatus
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 1/6/19.
 */
class SecurityStatusService(val lat: Double, val lon: Double, val timeStamp: Long) : BaseService<SecurityStatus>() {

    override fun createCall() {
        val request = createService(SecurityAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.getSecurityStatus(getDeviceId(), lat, lon, timeStamp, getAuthToken())
    }
}