package li.vin.my.apikit.services

import li.vin.my.apikit.api.DeviceAPI
import li.vin.my.apikit.models.Device
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 1/9/19.
 */
class DeviceDetailsService(val deviceID: String) : BaseService<Device>() {

    override fun createCall() {
        val request = createService(DeviceAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.getDeviceDetails(deviceID, getCookies())
    }
}