package li.vin.my.apikit.services

import li.vin.my.apikit.api.TripsAPI
import li.vin.my.apikit.models.Trips
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints
import java.text.SimpleDateFormat
import java.util.*

/**
 * 11/7/18.
 */
class TripService(val since: Long, val limit: Long, val myVinliCall: Boolean) : BaseService<Trips>() {
    constructor(since: Long, limit: Long, until: Long, myVinliCall: Boolean) : this(since, limit, myVinliCall) {
        this.until = until
    }

    var until = System.currentTimeMillis()

    override fun createCall() {
        val endPoint =
            if (myVinliCall) Endpoints.getVinliBaseUrl() else Endpoints.getAuthBaseUrl()
        val request = createService(TripsAPI::class.java, endPoint)
        val format = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        format.timeZone = TimeZone.getTimeZone("UTC")
        call = request.getTrips(getDeviceId(),
            format.format(Date(since)),
            limit,
            format.format(Date(until)),
            "desc",
            getCookies())
    }
}