package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/5/18.
 */
data class Session(@SerializedName("session") val session: SessionData?)

data class SessionData(
    @SerializedName("id") val id: String?,
    @SerializedName("firstName") val firstName: String?,
    @SerializedName("lastName") val lastName: String?,
    @SerializedName("email") val email: String?,
    @SerializedName("confirmed") val confirmed: Boolean?,
    @SerializedName("image") val image: String?,  //Unknown value so it is Object for now...
    @SerializedName("phone") val phone: String?,
    @SerializedName("password") val password: String?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("settings") val settings: SessionSettings?
)

data class SessionSettings(
    @SerializedName("unit") val unit: String?,
    @SerializedName("locale") val locale: String?,
    @SerializedName("country") val country: String?
)

enum class MeasureType constructor(val value: String) {

    METRIC("metric"),
    IMPERIAL("imperial");

    companion object {

        private val map = HashMap<String, MeasureType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): MeasureType {
            return map[value]!!
        }
    }
}

/**
"session": {
"id": "f36fc314-7bcf-44aa-8027-64294546e6e5",
"firstName": "John",
"lastName": "Smith",
"email": "jsmith@mail.com",
"image": null,
"phone": "+19999999999",
"createdAt": null,
"settings": {
"unit": "imperial"
}
}
 */