package li.vin.my.apikit.services

import li.vin.my.apikit.api.ForgotPasswordAPI
import li.vin.my.apikit.models.ForgotPassword
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class ResetPasswordService(val password: String, val token: String): BaseService<Void>() {
    constructor(password: String, token: String, theme: String) : this(password, token) {
        this.theme = theme
    }
    // default to no theme
    var theme = ""

    override fun createCall() {
        val request = createService(ForgotPasswordAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.postResetPassword(theme, ForgotPassword(password, token))
    }
}