package li.vin.my.apikit.services

import li.vin.my.apikit.api.AlertsAPI
import li.vin.my.apikit.models.Rule
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class AlertRuleService(val ruleId: String) : BaseService<Rule>() {

    override fun createCall() {
        val request = createService(AlertsAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.getRule(ruleId, getAuthToken())
    }
}