package li.vin.my.apikit.api

import li.vin.my.apikit.models.Telemetry
import li.vin.my.apikit.models.TelemetryLocations
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * 11/5/18.
 */
interface TelemetryAPI {
    @GET("/api/v1/devices/{deviceId}/snapshots")
    fun getTelemetry(
        @Path("deviceId") deviceId: String,
        @Query("fields") fields: String,
        @Query("limit") limits: Int
    ): Call<Telemetry>

    @GET("/api/v1/devices/{deviceId}/locations")
    fun getTelemetryLocations(
        @Path("deviceId") deviceId: String,
        @Query("limit") limit: Int
    ): Call<TelemetryLocations>
}