package li.vin.my.apikit.services

import li.vin.my.apikit.api.TagAPI
import li.vin.my.apikit.models.TagPostBody
import li.vin.my.apikit.models.UpdateTagData
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/4/18.
 */
class TripsTagUpdateService(val tagId: String, val tripId: String, val body: TagPostBody) :
    BaseService<UpdateTagData>() {

    override fun createCall() {
        val request = createService(TagAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.updateTag(tagId, tripId, body, getAuthToken())
    }
}