package li.vin.my.apikit.services

import li.vin.my.apikit.api.ForgotPasswordAPI
import li.vin.my.apikit.models.ForgotPassword
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class ResetPasswordService(val password: String, val token: String): BaseService<Void>() {

    override fun createCall() {
        val request = createService(ForgotPasswordAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.postResetPassword(ForgotPassword(password, token))
    }
}