package li.vin.my.apikit.api

import li.vin.my.apikit.models.Trips
import li.vin.my.apikit.models.TripsData
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * 11/7/18.
 */
interface TripsAPI {

    @GET("/api/v1/devices/{deviceId}/trips")
    fun getTrips(
        @Path("deviceId") deviceId: String,
        @Query("since") since: Long,
        @Query("limit") limit: Long,
        @Query("until") until: Long,
        @Header("Cookie") sessionCookie: String
    ): Call<Trips>

    @GET("/api/v2/trips/{tripId}/playback")
    fun getTripPlayBack(
        @Path("tripId") tripId: String,
        @Header("Authorization") auth: String
    ): Call<TripsData>

    @GET("/api/v2/trips/{tripId}/playback")
    fun getTripPlayBack(
        @Path("tripId") tripId: String,
        @Query("since") since: Long,
        @Header("Authorization") auth: String
    ): Call<TripsData>
}