package li.vin.my.apikit.services

import li.vin.my.apikit.api.TripsAPI
import li.vin.my.apikit.models.Trips
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 11/7/18.
 */
class TripService(val since: Long, val limit: Long, val myVinliCall: Boolean) : BaseService<Trips>() {
    constructor(since: Long, limit: Long, until: Long, myVinliCall: Boolean) : this(since, limit, myVinliCall) {
        this.until = until
    }

    var until = System.currentTimeMillis()

    override fun createCall() {
        val endPoint =
            if (myVinliCall) Endpoints.getVinliBaseUrl() else Endpoints.getAuthBaseUrl()
        val request = createService(TripsAPI::class.java, endPoint)
        call = request.getTrips(getDeviceId(), since, limit, until, getCookies())
    }
}