package li.vin.my.apikit.api

import li.vin.my.apikit.models.CommentPostBody
import li.vin.my.apikit.models.Comments
import retrofit2.Call
import retrofit2.http.*

/**
 * 12/18/18.
 */
interface CommentsAPI {

    @PUT("/api/v1/trips/{tripId}/comments/{commentId}")
    fun updateComment(
        @Path("tripId") tripId: String,
        @Path("commentId") commentId: String,
        @Body body: CommentPostBody,
        @Header("Authorization") auth: String
    ): Call<Comments>

    @POST("/api/v1/trips/{tripId}/comments")
    fun createComment(
        @Path("tripId") tripId: String,
        @Body body: CommentPostBody,
        @Header("Authorization") auth: String
    ): Call<Comments>

    @DELETE("/api/v1/trips/{tripId}/comments/{commentId}")
    fun deleteComment(
        @Path("tripId") tripId: String,
        @Path("commentId") commentId: String,
        @Header("Authorization") auth: String
    ): Call<Void>
}