package li.vin.my.apikit

import android.content.Context

import java.io.File

class ApiKit private constructor(val context: Context, val baseUrl: String, val isDebug: Boolean, val cacheDir: File) {

    companion object {
        private var apikit: ApiKit? = null

        fun getInstance(context: Context): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", false, context.cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, false, context.cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String, isDebug: Boolean): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, isDebug, context.cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, false, cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, isDebug: Boolean): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", isDebug, context.cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, isDebug: Boolean, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", isDebug, cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", false, cacheDir)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String, isDebug: Boolean, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, isDebug, cacheDir)
            }
            return apikit!!
        }

        val instance: ApiKit
            get() {
                if (apikit == null) {
                    throw IllegalStateException("Apikit context not set")
                }
                return apikit!!
            }
    }
}
