package li.vin.my.apikit.services

import com.google.gson.Gson
import li.vin.my.apikit.AuthSettings
import li.vin.my.apikit.api.TheftAPI
import li.vin.my.apikit.models.*
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 1/14/19.
 */
class TheftService(val timeStamp: String, val title: String, val body: String) : BaseService<Void>() {

    override fun createCall() {
        val request = createService(TheftAPI::class.java, Endpoints.getVinliBaseUrl())
        val session = Gson().fromJson(AuthSettings.instance.getCurrentSessionString(), Session::class.java)
        val userData = TheftData(title, body, getDeviceId(), true, session.session?.id)
        val subscriptionData = TheftPushData(TheftPushSubscription(userData), TheftEvent(timeStamp))
        val notification = TheftNotification(subscriptionData)
        call = request.theftNotification(notification)
    }
}