package li.vin.my.apikit.services

import li.vin.my.apikit.api.EventsAPI
import li.vin.my.apikit.models.SingleEvent
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class EventsService(val eventId: String) : BaseService<SingleEvent>() {

    override fun createCall() {
        val request = createService(EventsAPI::class.java, Endpoints.getEventsUrl())
        call = request.getEvent(eventId, getCookies())
    }
}