package li.vin.my.apikit.api

import li.vin.my.apikit.models.GcmToken
import li.vin.my.apikit.models.TheftNotification
import retrofit2.Call
import retrofit2.http.*

/**
 * 1/13/19.
 */
interface TheftAPI {

    @POST("/api/v1/notifications")
    fun theftNotification(@Body payload: TheftNotification): Call<Void>

    @PUT("/api/v1/push/register")
    fun updateGcmToken(@Body token: GcmToken, @Header("Cookie") sessionCookie: String): Call<Void>

    @DELETE("/api/v1/push/register/{registrationId}")
    fun deleteGcmToken(
        @Path("registrationId") registrationId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>
}