package li.vin.my.apikit

import android.content.Context
import li.vin.my.apikit.network.ReceivedCookiesInterceptor
import okhttp3.Cache
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor

import java.io.File

class ApiKit private constructor(val context: Context, val baseUrl: String, val isDebug: Boolean, val cacheDir: File) {

    companion object {
        private var apikit: ApiKit? = null
        val okHttpClientBuilder = OkHttpClient.Builder()
        lateinit var okHttpClient: OkHttpClient
        var debugLogging = false

        fun getInstance(context: Context): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", false, context.cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, false, context.cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String, isDebug: Boolean, debugLogging: Boolean): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, isDebug, context.cacheDir)
                this.debugLogging = debugLogging
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, false, cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, isDebug: Boolean): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", isDebug, context.cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, isDebug: Boolean, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", isDebug, cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, "vin.li", false, cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        fun getInstance(context: Context, baseUrl: String, isDebug: Boolean, cacheDir: File): ApiKit {
            if (apikit == null) {
                apikit = ApiKit(context, baseUrl, isDebug, cacheDir)
                initializeOkHttp(context)
            }
            return apikit!!
        }

        private fun getAuthToken(): String {
            if (ApiKit.instance.isDebug) {
                return "Bearer 3nnVgoPsxFVNo4jvgbj8zpexFvVfsMZ58mCpMg2HsAVLmAc1dt_FIL_ZBPRG07fr"
            } else {
                return AuthSettings.instance.getAuthToken()
            }
        }

        private fun initializeOkHttp(context: Context) {
            AuthSettings.getInstance(context)
            val cacheSize: Long = 10 * 1024 * 1024 // 10 MB
            val cacheDir = Cache(instance.cacheDir, cacheSize)
            okHttpClientBuilder.cache(cacheDir)
            val logging = HttpLoggingInterceptor()
            logging.level = if (debugLogging) HttpLoggingInterceptor.Level.BODY else HttpLoggingInterceptor.Level.BASIC
            okHttpClientBuilder.addInterceptor(logging)
            okHttpClientBuilder.addInterceptor(ReceivedCookiesInterceptor())
            if (AuthSettings.instance.getAuthToken() != "Bearer" || ApiKit.instance.isDebug) {
                okHttpClientBuilder.addInterceptor(Interceptor { chain ->
                    val original = chain.request()
                    val requestBuilder = original.newBuilder()
                        .header("Authorization", getAuthToken())
                        .method(original.method(), original.body())
                    val request = requestBuilder.build()
                    chain.proceed(request)
                })
            }
            okHttpClient = okHttpClientBuilder.build()
        }

        val instance: ApiKit
            get() {
                if (apikit == null) {
                    throw IllegalStateException("Apikit context not set")
                }
                return apikit!!
            }
    }
}
