package li.vin.my.apikit.services

import li.vin.my.apikit.api.TripsAPI
import li.vin.my.apikit.models.TripsData
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/13/18.
 */
class TripPlayBackService(val tripId: String) : BaseService<TripsData>() {
    constructor(tripId: String, since: Long) : this(tripId) {
        this.since = since
    }

    var since = 0L

    override fun createCall() {
        val request = createService(TripsAPI::class.java, Endpoints.getVinliBaseUrl())
        if (since != 0L) {
            call = request.getTripPlayBack(tripId, since, getAuthToken())
        } else {
            call = request.getTripPlayBack(tripId, getAuthToken())
        }
    }
}